﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net.Mail;
using System.Web;
using System.Web.Services;
using AZVIC.Ei8htPOS.Utilities;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.BAL;

namespace AZVIC.Ei8htPOS.WebUI.WebService
{
    /// <summary>
    /// Summary description for SendEmail
    /// </summary>
    [WebService(Namespace = "http://tempuri.org/")]
    [WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
    // To allow this Web Service to be called from script, using ASP.NET AJAX, uncomment the following line. 
    [System.Web.Script.Services.ScriptService]
    public class ContactService : System.Web.Services.WebService
    {
        [WebMethod]
        public string SendContactUsEmail(string name, string address, string companyname, string city, string phoneno, string country, string email, string subject, string message)
        {
            if (!ValidationUtility.ValidateString(name))
                return "Please enter valid Name";
            if (!ValidationUtility.ValidateString(address))
                return "Please enter valid Address";
            if (!ValidationUtility.ValidateString(companyname))
                return "Please enter valid Company Name";
            if (!ValidationUtility.ValidateString(city))
                return "Please enter valid City";
            if (!ValidationUtility.ValidatephoneNo(phoneno))
                return "Please enter valid Phone No.";
            if (!ValidationUtility.ValidateString(country))
                return "Please enter valid Country";
            if (!ValidationUtility.ValidateEmail(email))
                return "Please enter valid Email";
            if (!ValidationUtility.ValidateString(subject))
                return "Please enter valid Subject";
            if (!ValidationUtility.ValidateString(message))
                return "Please enter valid Message";

            try
            {
                string emailBody = string.Empty;

                #region EMail Body
                emailBody += @"<html lang=""en"" xmlns=""http://www.w3.org/1999/xhtml"">
                                    <head><title></title></head>
                                    <body style=""font-family: 'Arial', 'sans-serif'; font-size: 15px; padding: 0; margin: 0;"">
                                        <table width=""740"" cellspacing=""0"" cellpadding=""0"" align=""center"" style=""padding: 5px 3px 5px 10px;"">
                                            <tr>
                                                <td align=""left"">
                                                    Feedback from Contact us Page
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <hr style=""margin-bottom: 20px;"" />
                                                </td>
                                            </tr>
                                            <tr>
                                                <td style=""font-family: 'Arial', 'sans-serif'; padding-top: 15px; line-height: 25px;"">
                                                    <p>Dear AZVIC Team</p>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td style=""font-family: 'Arial', 'sans-serif'; padding-top: 15px; line-height: 25px;"">
                                                    <p>
                                                        We have some feedback from online customer. Below are the details
                                                    </p>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td style=""font-family: 'Arial', 'sans-serif'; padding-top: 15px; line-height: 25px;"">
                                                    <table style=""border-collapse: collapse; font-size: 13px; width: 100%; padding: 5px 3px 5px 10px;border: 1px solid #ccc;"">
                                                        <tr style=""font-family: 'Arial', 'sans-serif'; padding: 5px; text-align: center;background: #4d4d4d; border: 1px solid #333; color: #fff;"">
                                                            <td align=""right"" valign=""top"" style=""border: 1px solid #ccc; text-align: right; font-family: 'Arial', 'sans-serif';width:20%;"">
                                                            Name :
                                                             </td>
                                                            <td valign=""top"" style=""border: 1px solid #ccc; text-align: left; font-family: 'Arial', 'sans-serif';width:80%;"">"
                                                                    + name +
                                                                     @"</td>
                                                        </tr>
                                                        <tr style=""font-family: 'Arial', 'sans-serif'; padding: 5px; text-align: center;background: #4d4d4d; border: 1px solid #333; color: #fff;"">
                                                            <td align=""right"" valign=""top"" style=""border: 1px solid #ccc; text-align: right; font-family: 'Arial', 'sans-serif';width:20%;"">
                                                            Address :
                                                             </td>
                                                            <td valign=""top"" style=""border: 1px solid #ccc; text-align: left; font-family: 'Arial', 'sans-serif';width:80%;"">"
                                                                    + address +
                                                                     @"</td>
                                                        </tr>
                                                        <tr style=""font-family: 'Arial', 'sans-serif'; padding: 5px; text-align: center;background: #4d4d4d; border: 1px solid #333; color: #fff;"">
                                                            <td align=""right"" valign=""top"" style=""border: 1px solid #ccc; text-align: right; font-family: 'Arial', 'sans-serif';width:20%;"">
                                                            Company Name :
                                                             </td>
                                                            <td valign=""top"" style=""border: 1px solid #ccc; text-align: left; font-family: 'Arial', 'sans-serif';width:80%;"">"
                                                                    + companyname +
                                                                     @"</td>
                                                        </tr>
                                                        <tr style=""font-family: 'Arial', 'sans-serif'; padding: 5px; text-align: center;background: #4d4d4d; border: 1px solid #333; color: #fff;"">
                                                            <td align=""right"" valign=""top"" style=""border: 1px solid #ccc; text-align: right; font-family: 'Arial', 'sans-serif';width:20%;"">
                                                            City :
                                                             </td>
                                                            <td valign=""top"" style=""border: 1px solid #ccc; text-align: left; font-family: 'Arial', 'sans-serif';width:80%;"">"
                                                                    + city +
                                                                     @"</td>
                                                        </tr>
                                                        <tr style=""font-family: 'Arial', 'sans-serif'; padding: 5px; text-align: center;background: #4d4d4d; border: 1px solid #333; color: #fff;"">
                                                            <td align=""right"" valign=""top"" style=""border: 1px solid #ccc; text-align: right; font-family: 'Arial', 'sans-serif';width:20%;"">
                                                            Phone No. :
                                                             </td>
                                                            <td valign=""top"" style=""border: 1px solid #ccc; text-align: left; font-family: 'Arial', 'sans-serif';width:80%;"">"
                                                                    + phoneno +
                                                                     @"</td>
                                                        </tr>
                                                        <tr style=""font-family: 'Arial', 'sans-serif'; padding: 5px; text-align: center;background: #4d4d4d; border: 1px solid #333; color: #fff;"">
                                                            <td align=""right"" valign=""top"" style=""border: 1px solid #ccc; text-align: right; font-family: 'Arial', 'sans-serif';width:20%;"">
                                                            Country :
                                                             </td>
                                                            <td valign=""top"" style=""border: 1px solid #ccc; text-align: left; font-family: 'Arial', 'sans-serif';width:80%;"">"
                                                                    + country +
                                                                     @"</td>
                                                        </tr>
                                                        <tr style=""font-family: 'Arial', 'sans-serif'; padding: 5px; text-align: center;background: #4d4d4d; border: 1px solid #333; color: #fff;"">
                                                            <td align=""right"" valign=""top"" style=""border: 1px solid #ccc; text-align: right; font-family: 'Arial', 'sans-serif';width:20%;"">
                                                            Email :
                                                             </td>
                                                            <td valign=""top"" style=""border: 1px solid #ccc; text-align: left; font-family: 'Arial', 'sans-serif';width:80%;"">
                                                                <a href='mailto:" + email + "'>"
                                                                    + email +
                                                                     @"</a></td>
                                                        </tr>
                                                        <tr style=""font-family: 'Arial', 'sans-serif'; padding: 5px; text-align: center;background: #4d4d4d; border: 1px solid #333; color: #fff;"">
                                                            <td align=""right"" valign=""top"" style=""border: 1px solid #ccc; text-align: right; font-family: 'Arial', 'sans-serif';width:20%;"">
                                                            Subject :
                                                             </td>
                                                            <td valign=""top"" style=""border: 1px solid #ccc; text-align: left; font-family: 'Arial', 'sans-serif';width:80%;"">"
                                                                    + subject +
                                                                     @"</td>
                                                        </tr>
                                                        <tr style=""font-family: 'Arial', 'sans-serif'; padding: 5px; text-align: center;background: #4d4d4d; border: 1px solid #333; color: #fff;"">
                                                            <td align=""right"" valign=""top"" style=""border: 1px solid #ccc; text-align: right; font-family: 'Arial', 'sans-serif';width:20%;"">
                                                            Message :
                                                             </td>
                                                            <td valign=""top"" style=""border: 1px solid #ccc; text-align: left; font-family: 'Arial', 'sans-serif';width:80%;"">"
                                                                    + message +
                                                                     @"</td>
                                                        </tr>
                                                    </table>
                                                </td>
                                            </tr>       
                                        </table>
                                    </body>
                                </html>";
                #endregion

                MailMessage msg = new MailMessage();
                msg.IsBodyHtml = true;
                msg.Subject = subject;
                msg.Body = emailBody;
                try
                {
                    if (email.Trim().Length != 0)
                        msg.From = new MailAddress(email.Trim());
                    else
                        msg.To.Add(new MailAddress("sales@azvic.com"));
                }
                catch { }

                //BCC List From Code
                msg.Bcc.Add("sam@azvic.com");
                msg.Bcc.Add("haja@azvic.com");
                msg.Bcc.Add("pearlyn@azvic.com");
                msg.Bcc.Add("anthonylauw@azvic.com");
                msg.Bcc.Add("patrick@azvic.com");

                Sendmail(msg);

                ContactUs myCon = new ContactUs();
                myCon.Mode = GlobalConfigurations.Mode.Insert;
                myCon.Name = name;
                myCon.CAddress = address;
                myCon.CompanyName = companyname;
                myCon.City = city;
                myCon.PhoneNo = phoneno;
                myCon.Country = country;
                myCon.Email = email;
                myCon.CSubject = subject;
                myCon.CMessage = message;

                ContactUsBL.Save(myCon);

                //System.Threading.Thread.Sleep(3000);
            }
            catch { }

            return "Thank you for contacting AZVIC. Our sales team will contact you soon.";
        }

        [WebMethod]
        public string SaveNewsLetterEmail(string email)
        {

            if (!ValidationUtility.ValidateEmail(email))
                return "Please enter valid Email";

            Subscription mySub = new Subscription();
            mySub.Mode = GlobalConfigurations.Mode.Insert;

            mySub.Email = email;
            mySub.IsSubscribed = true;

            SubscriptionBL.Save(mySub);
            //System.Threading.Thread.Sleep(3000);

            return "Thank you for subscribe with AZVIC.";
        }

        [WebMethod]
        public string SaveSubscription(string salutaion, string fullname, string companyName, string email)
        {
            if (!ValidationUtility.ValidateString(fullname))
                return "Please enter valid Email";
            if (!ValidationUtility.ValidateEmail(email))
                return "Please enter valid Email";

            Subscription mySub = new Subscription();
            mySub.Mode = GlobalConfigurations.Mode.Insert;

            mySub.Salutaion = salutaion;
            mySub.FullName = fullname;
            mySub.CompanyName = companyName;
            mySub.Email = email;
            mySub.IsSubscribed = true;

            SubscriptionBL.Save(mySub);
            //System.Threading.Thread.Sleep(3000);

            return "Thank you for subscribe with AZVIC.";
        }

        [WebMethod]
        public string GetCurrentCaptcha()
        {
            CatpchaImage captcha = new CatpchaImage();
            return captcha.DrawNumbers(5, string.Empty);
        }

        public void Sendmail(MailMessage message)
        {
            SmtpClient client = new SmtpClient("smtp.gmail.com", 587);
            client.Credentials = new System.Net.NetworkCredential("sales@azvic.com", "azvicsales123");
            client.DeliveryMethod = SmtpDeliveryMethod.Network;
            client.EnableSsl = true;
            try
            {
                client.Send(message);
            }
            catch { }
        }
    }
}
